<?php

namespace App\Http\Controllers;

use App\Information;
use App\Mail\ContactMail;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Mail;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;

class HomeController extends Controller
{
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('welcome');
    }

    public function register(Request $request)
    {
       // return Redirect::back()->withErrors(['msg' => 'succcccccc']);
     $user =User::where('email',$request->email)->first();
     if (empty($user->email)){
         return Redirect::back()->withErrors(['msg' => 'this email not invented']);
     }
     else{
         User::where( 'email',$request->email)->update([
             'name'=>$request->name,

             'seat_num'=>$request->seat_num,
             'created_at'=> Carbon::now()->setTime(0,0)->format('Y-m-d H:i:s'),
             'updated_at'=> Carbon::now()->setTime(0,0)->format('Y-m-d H:i:s'),
         ]);

         $id = User::where('email',$request->email)->first();

         Information::create([
         'user_id'=>$id->id,
         'postion'=>$request->postion,
         'side'=>$request->side,
         'phone'=>$request->phone,
         'question'=>$request->question,
             'created_at'=> Carbon::now()->setTime(0,0)->format('Y-m-d H:i:s'),
             'updated_at'=> Carbon::now()->setTime(0,0)->format('Y-m-d H:i:s'),

         ]);





         Session::flash('message', "Registertion has been submiited Successfuly");
         return Redirect::back();

     }


    }



    public function redirect()
    {
        if (auth()->user()->is_admin) {
            return redirect()->route('admin.home')->with('status', session('status'));
        }

        return redirect()->route('client.home')->with('status', session('status'));
    }


    public function email(Request $request){
       // return $request;
        $detalis =[
            'member_id'=>$request->member_id,
            'bill'=>$request->bill,
            'name'=>$request->name,
            'phone'=>$request->phone,
            'car_type'=>$request->car_type,
            'chassie'=>$request->chassie,
            'bord_number'=>$request->bord_number,
            'model'=>$request->model,
            'date'=>$request->date,
        ];
        Mail::to('onlinestore2019.2020@gmail.com')->send(new ContactMail($detalis));

        Session::flash('message', "تم ارسال البريد بنجاح");
        return Redirect::back();
    }

}
